/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodepreference;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.setting.step.nodepreference.NodePreference;
import com.pmease.quickbuild.setting.step.nodepreference.PreferLeastLoadedNode;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.stepsupport.StepRuntime;
import java.util.Collection;

@Editable(name="Prefer node running this step previously", order=200)
public class PreferNodeRunningThisStepPreviously
implements NodePreference {
    private static final long serialVersionUID = 1L;

    @Override
    public GridNode getPreference(Collection<GridNode> nodes, Step step) {
        StepRuntime runtime;
        Build build = Context.getBuild() != null ? Context.getBuild().getPreviousFinished() : Context.getConfiguration().getLatestFinishedBuild();
        if (build != null && (runtime = build.getStepRuntimes().get(step.getPath().toString())) != null && runtime.getNodeAddress() != null) {
            for (GridNode node : nodes) {
                if (!node.getAddress().equals(runtime.getNodeAddress())) continue;
                return node;
            }
        }
        return new PreferLeastLoadedNode().getPreference(nodes, step);
    }
}

