/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodepreference;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.nodepreference.NodePreference;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.Collection;
import org.apache.commons.lang.Validate;

@Editable(name="Prefer least used node", order=300)
public class PreferLeastUsedNode
implements NodePreference {
    private static final long serialVersionUID = 1L;

    @Override
    public GridNode getPreference(Collection<GridNode> nodes, Step step) {
        long minUsed = Long.MAX_VALUE;
        GridNode selected = null;
        for (GridNode node : nodes) {
            long used = node.getUsedCount();
            if (used >= minUsed) continue;
            minUsed = used;
            selected = node;
        }
        Validate.notNull(selected);
        return selected;
    }
}

