/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodepreference;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.nodepreference.NodePreference;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.Collection;
import org.apache.commons.lang.Validate;

@Editable(name="Prefer least loaded node", order=100)
public class PreferLeastLoadedNode
implements NodePreference {
    private static final long serialVersionUID = 1L;

    @Override
    public GridNode getPreference(Collection<GridNode> nodes, Step step) {
        long minLoad = Long.MAX_VALUE;
        GridNode selected = null;
        for (GridNode node : nodes) {
            long load = node.predictLoad();
            if (load >= minLoad) continue;
            minLoad = load;
            selected = node;
        }
        Validate.notNull(selected);
        return selected;
    }
}

