/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodematcher;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.nodematcher.MatchResult;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.EasyMap;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="On node with specified script evaluating to true", order=200)
@Current(value=Step.class)
public class ScriptNodeMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private String script;

    @Editable(description="Specify the script to evaulate. The node to be matched is available as <b>node</b> object in the script context. Please note that this script will always be executed on server although node object can be different than server.")
    @Script
    @Scriptable
    @NotEmpty
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public MatchResult matches(Step step, GridNode node) {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        Map<String, Object> evalContext = Context.buildEvalContext(step, EasyMap.create("node", node));
        Object result = scriptEngine.evaluate(this.getScript(), evalContext);
        if (result instanceof MatchResult) {
            return (MatchResult)result;
        }
        Boolean matched = (Boolean)result;
        if (matched.booleanValue()) {
            return new MatchResult(true, "Script returns true for this node");
        }
        return new MatchResult(false, "Script returns false for this node");
    }
}

