/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodematcher;

import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.nodematcher.MatchResult;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="On node with address equals to specified step parameter", order=196)
@Current(value=Step.class)
public class ParamNodeMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private String param;

    @Editable(name="Parameter Name", description="Specify name of the step parameter to use as node address.")
    @NotEmpty
    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    @Override
    public MatchResult matches(Step step, GridNode node) {
        boolean result = step.getParam(this.getParam()).equals(node.getAddress());
        if (result) {
            return new MatchResult(true, "Address equals to step param '" + this.getParam() + "'");
        }
        return new MatchResult(false, "Address does not equal to step param '" + this.getParam() + "'");
    }
}

