/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodematcher;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.nodematcher.AttributeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.MatchResult;
import com.pmease.quickbuild.stepsupport.Step;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="On node with specified attribute value", order=190)
public class HashAttributeValueMatcher
extends AttributeMatcher {
    private static final long serialVersionUID = 1L;
    private Operator operator;
    private String value;

    @Editable(order=20)
    @NotNull
    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    @Editable(order=30, description="Specify expected value here. In case of operator <em>matches_regular_expression</em>, this field expects a <a href=\"http://java.sun.com/j2se/1.4.2/docs/api/java/util/regex/Pattern.html\">Java regular expression pattern</a>.")
    @NotEmpty
    @Scriptable
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public MatchResult matches(Step step, GridNode node) {
        boolean result = this.getOperator().isSatisfied(node.getAttribute(this.getAttribute(), ""), this.getValue());
        if (result) {
            return new MatchResult(true, "Value of attribute '" + this.getAttribute() + "'\n" + this.getOperator().name() + " " + this.getValue());
        }
        return new MatchResult(false, "Value of attribute '" + this.getAttribute() + "'\ndoes not " + this.getOperator().name() + " " + this.getValue());
    }

    public static enum Operator {
        equals{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.equals(expected);
            }
        }
        ,
        equals_ignore_case{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.equalsIgnoreCase(expected);
            }
        }
        ,
        contains{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.contains(expected);
            }
        }
        ,
        matches_regular_expression{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.matches(expected);
            }
        }
        ,
        begin_with{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.startsWith(expected);
            }
        }
        ,
        ends_with{

            @Override
            public boolean isSatisfied(String actual, String expected) {
                return actual.endsWith(expected);
            }
        };


        public abstract boolean isSatisfied(String var1, String var2);
    }
}

