/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodematcher;

import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ExpressionProvider;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Resource;
import com.pmease.quickbuild.setting.step.nodematcher.MatchResult;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="On node with specified resource", order=15)
public class HasResourceMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private String resource;

    @Override
    public MatchResult matches(Step step, GridNode node) {
        boolean result = node.hasResource(this.getResource());
        if (result) {
            return new MatchResult(true, "Has resource '" + this.getResource() + "'");
        }
        return new MatchResult(false, "Does not have resource '" + this.getResource() + "'");
    }

    @Editable(name="Resource")
    @NotEmpty
    @Scriptable
    @ExpressionProvider(value="getResourceChoices")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    private static Map<String, String> getResourceChoices() {
        LinkedHashMap<String, String> choices = new LinkedHashMap<String, String>();
        List<Resource> resources = CacheManager.instance.getResources();
        Collections.sort(resources, new Comparator<Resource>(){

            @Override
            public int compare(Resource r1, Resource r2) {
                return r1.getName().compareTo(r2.getName());
            }
        });
        for (Resource resource : resources) {
            choices.put(resource.getName(), resource.getName());
        }
        return choices;
    }
}

