/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodematcher;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.AgentManager;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.nodematcher.MatchResult;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="On specified build agent", order=100)
public class BuildAgentMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private String address;

    @Editable(name="Build Agent")
    @ChoiceProvider(value="getAvailableBuildAgents")
    @NotEmpty
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    private static List<String> getAvailableBuildAgents() {
        List<GridNode> nodes = Quickbuild.getInstance(AgentManager.class).getBuildAgents();
        Collections.sort(nodes, new Comparator<GridNode>(){

            @Override
            public int compare(GridNode node1, GridNode node2) {
                return node1.getAddress().compareTo(node2.getAddress());
            }
        });
        ArrayList<String> nodeAddresses = new ArrayList<String>();
        for (GridNode node : nodes) {
            nodeAddresses.add(node.getAddress());
        }
        return nodeAddresses;
    }

    @Override
    public MatchResult matches(Step step, GridNode node) {
        boolean result = node.getAddress().equals(this.getAddress());
        if (result) {
            return new MatchResult(true, "Is build agent '" + this.getAddress() + "'");
        }
        return new MatchResult(false, "Is not build agent '" + this.getAddress() + "'");
    }
}

