/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.nodematcher;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.step.nodematcher.MatchResult;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcher;
import com.pmease.quickbuild.setting.step.nodematcher.NodeMatcherCriteria;
import com.pmease.quickbuild.stepsupport.Step;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="On node matching all specified criterias", order=210)
public class AndMatcher
implements NodeMatcher {
    private static final long serialVersionUID = 1L;
    private List<NodeMatcherCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<NodeMatcherCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<NodeMatcherCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public MatchResult matches(Step step, GridNode node) {
        ArrayList<String> reasons = new ArrayList<String>();
        for (NodeMatcherCriteria each : this.getCriterias()) {
            MatchResult result = each.getCriteria().matches(step, node);
            if (!result.isMatched()) {
                return new MatchResult(false, result.getReasons());
            }
            reasons.addAll(result.getReasons());
        }
        return new MatchResult(true, reasons);
    }
}

