/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.executecondition;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.step.executecondition.ExecuteCondition;
import com.pmease.quickbuild.stepsupport.Step;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="If specified script evaluates to true", order=50)
@Current(value=Step.class)
public class ScriptExecuteCondition
implements ExecuteCondition {
    private static final long serialVersionUID = 1L;
    private String script;

    @Editable(description="Specify the script to evaulate. The <b>node</b> object in this script context represents the node running parent step (or server node if no parent step. Please note that this script will be evaluated on node running the parent step as the node running current step is only assigned if step execute condition evaluates to true.")
    @Script
    @Scriptable
    @NotEmpty
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public boolean satisfied(Step step) {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        return (Boolean)scriptEngine.evaluate(this.getScript(), Context.buildEvalContext(step, null));
    }
}

