/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.executecondition;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.step.executecondition.ExecuteCondition;
import com.pmease.quickbuild.stepsupport.Step;
import java.io.File;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="If specified path exists", order=46)
@Current(value=Step.class)
public class FileExistExecuteCondition
implements ExecuteCondition {
    private static final long serialVersionUID = 1L;
    private String path;

    @Editable(description="Specify path to check. Non-absolute path is considered to be relative to workspace of current configuration")
    @NotEmpty
    @Scriptable
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public boolean satisfied(Step step) {
        String path = this.getPath();
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(Context.getConfiguration().getWorkspaceDir(), path);
        }
        return file.exists();
    }
}

