/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.executeaction;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.step.executeaction.ExecuteAction;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Delete specified files on current node if specified variable is true", order=80)
@Current(value=Step.class)
public class DeleteFilesConditionally
implements ExecuteAction {
    private static final long serialVersionUID = 1L;
    private String directory;
    private String patterns;
    private String variable;

    @Editable(order=100, description="Specify the directory from which to delete files. A non-absolute path is considered to be relative to the workspace. If not specified, the workspace directory itself will be assumed.")
    @Scriptable
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Editable(order=200, name="Files", description="Specify patterns of files to be deleted. Patterns will be matched under the directory specified above.Refer to <a href=\"$docroot/File+Pattern+Reference\" target=\"_blank\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @Scriptable
    @NotEmpty
    public String getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String patterns) {
        this.patterns = patterns;
    }

    @Editable(order=300, description="Specify the variable to evaulate. Files will only be deleted if value of specified variable equals (case insensitive) to \"true\", \"t\", \"yes\", or \"y\".")
    @ChoiceProvider(value="getAvailableVariables")
    @NotEmpty
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    private static List<String> getAvailableVariables() {
        ArrayList<String> varNames = new ArrayList<String>(Context.getConfiguration().findVariableNames());
        Collections.sort(varNames);
        return varNames;
    }

    @Override
    public void execute(Step step) {
        File dir;
        VariableWrapper var = Context.get().getVar(this.getVariable());
        if (var == null) {
            throw new QuickbuildException("Variable not found: " + this.getVariable());
        }
        if (var.asBoolean() && (dir = FileUtils.resolvePath(Context.getConfiguration().getWorkspaceDir(), this.getDirectory())).exists()) {
            FileUtils.deleteFiles(dir, this.getPatterns());
        }
    }
}

