/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.executeaction;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.step.executeaction.ExecuteAction;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Delete specified files on current node", order=80)
@Current(value=Step.class)
public class DeleteFiles
implements ExecuteAction {
    private static final long serialVersionUID = 1L;
    private String directory;
    private String patterns;

    @Editable(order=100, description="Specify the directory from which to delete files. A non-absolute path is considered to be relative to the workspace. If left empty, the workspace directory itself will be assumed.")
    @Scriptable
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Editable(order=200, name="Files", description="Specify patterns of files to be deleted. Patterns will be matched under the directory specified above.Refer to <a href=\"$docroot/File+Pattern+Reference\" target=\"_blank\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @Scriptable
    @NotEmpty
    public String getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String patterns) {
        this.patterns = patterns;
    }

    @Override
    public void execute(Step step) {
        File dir = FileUtils.resolvePath(Context.getConfiguration().getWorkspaceDir(), this.getDirectory());
        if (dir.exists()) {
            FileUtils.deleteFiles(dir, this.getPatterns());
        }
    }
}

