/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.executeaction;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.setting.step.executeaction.ExecuteAction;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Clean workspace on current node if specified variable is true", order=15)
public class CleanWorkspaceConditionally
implements ExecuteAction {
    private static final long serialVersionUID = 1L;
    private String variable;

    @Editable(description="Specify the variable to evaulate. Evaluation will be true if value of specified variable equals (case insensitive) to \"true\", \"t\", \"yes\", or \"y\".")
    @ChoiceProvider(value="getAvailableVariables")
    @NotEmpty
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    private static List<String> getAvailableVariables() {
        ArrayList<String> varNames = new ArrayList<String>(Context.getConfiguration().findVariableNames());
        Collections.sort(varNames);
        return varNames;
    }

    @Override
    public void execute(Step step) {
        VariableWrapper var = Context.get().getVar(this.getVariable());
        if (var == null) {
            throw new QuickbuildException("Variable not found: " + this.getVariable());
        }
        if (var.asBoolean()) {
            FileUtils.cleanDir(Context.getConfiguration().getWorkspaceDir());
        }
    }
}

