/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.executeaction;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.step.executeaction.ExecuteAction;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Clean specified directory on current node if specified variable evaluates to true", order=25)
@Current(value=Step.class)
public class CleanDirectoryConditionally
implements ExecuteAction {
    private static final long serialVersionUID = 1L;
    private String directory;
    private String variable;

    @Editable(order=100, description="Specify the directory to clean. A non-absolute path is considered to be relative to the workspace.")
    @Scriptable
    @NotEmpty
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Editable(order=200, description="Specify the variable to evaulate. Evaluation will be true if value of specified variable equals (case insensitive) to \"true\", \"t\", \"yes\", or \"y\".")
    @ChoiceProvider(value="getAvailableVariables")
    @NotEmpty
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    private static List<String> getAvailableVariables() {
        ArrayList<String> varNames = new ArrayList<String>(Context.getConfiguration().findVariableNames());
        Collections.sort(varNames);
        return varNames;
    }

    @Override
    public void execute(Step step) {
        VariableWrapper var = Context.get().getVar(this.getVariable());
        if (var == null) {
            throw new QuickbuildException("Variable not found: " + this.getVariable());
        }
        if (var.asBoolean()) {
            FileUtils.cleanDir(FileUtils.resolvePath(Context.getConfiguration().getWorkspaceDir(), this.getDirectory()));
        }
    }
}

