/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step.executeaction;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.step.executeaction.ExecuteAction;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.util.FileUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Clean specified directory on current node", order=20)
@Current(value=Step.class)
public class CleanDirectory
implements ExecuteAction {
    private static final long serialVersionUID = 1L;
    private String directory;

    @Editable(description="Specify the directory to clean. A non-absolute path is considered to be relative to the workspace.")
    @Scriptable
    @NotEmpty
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Override
    public void execute(Step step) {
        FileUtils.cleanDir(FileUtils.resolvePath(Context.getConfiguration().getWorkspaceDir(), this.getDirectory()));
    }
}

