/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.step;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.Scriptable;
import java.io.Serializable;
import org.hibernate.validator.constraints.NotEmpty;

public class FileTransferOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String srcPath;
    private String filePatterns = "**";
    private String destPath;
    private boolean compress;
    private boolean transferIfFailed;

    @Editable(name="Source Path", order=100, description="Specified path is considered to be relative to source workspace if it is not an absolute path. If not specified, the source workspace directory is assumed.")
    @Scriptable
    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Editable(name="Files To Transfer", order=200, description="Specify files to transfer under above source path. Patterns can be used to match multiple files, for example: <b>src/*.cpp</b> will fetch all cpp files under the <b>src</b> directory. Refer to <a href=\"$docroot/File+Pattern+Reference\" target=\"_blank\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @NotEmpty
    @Scriptable
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String filePatterns) {
        this.filePatterns = filePatterns;
    }

    @Editable(name="Destination Path", order=300, description="Specified path is considered to be relative to the destination workspace if it is not an absolute path. If not specified, the destination workspace directory is assumed.")
    @Scriptable
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }

    @Editable(name="Compress During Transfer?", order=200)
    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    @Editable(name="Transfer Even If Step is Failed", order=300)
    public boolean isTransferIfFailed() {
        return this.transferIfFailed;
    }

    public void setTransferIfFailed(boolean transferIfFailed) {
        this.transferIfFailed = transferIfFailed;
    }
}

