/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.repository.usermapping;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.setting.repository.usermapping.UserMapping;
import com.pmease.quickbuild.util.EasyMap;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Map with a script", order=30)
@Current(value=Repository.class)
public class ScriptMapping
implements UserMapping {
    private static final long serialVersionUID = 1L;
    private String script;

    @Editable(description="Specify the script to map committer name (available as script object <em>committer</em>) to name of a QuickBuild user (taken from script evaluation result).")
    @NotEmpty
    @Script
    @Scriptable
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public String map(Repository<?> repository, String committer) {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        return (String)scriptEngine.evaluate(this.getScript(), Context.buildEvalContext(repository, EasyMap.create("committer", committer)));
    }
}

