/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.repository.usermapping;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.setting.repository.usermapping.UserMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Map with a list", order=20)
public class ListMapping
implements UserMapping {
    private static final long serialVersionUID = 1L;
    private List<Entry> entries;

    @Editable(name="Mappings", description="Specify SCM committer to QuickBuild user mapping here. Committer not appearing in this mapping will be mapped to user with the same name.")
    @Size(min=1, max=10000)
    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    public String map(Repository<?> repository, String committer) {
        for (Entry entry : this.entries) {
            if (!committer.equals(entry.getCommitter())) continue;
            return entry.getUserName();
        }
        return committer;
    }

    public static class Entry
    implements Serializable,
    Comparable<Entry> {
        private static final long serialVersionUID = 1L;
        private String committer;
        private String userName;

        @Editable(name="SCM Committer", order=10)
        @NotEmpty
        public String getCommitter() {
            return this.committer;
        }

        public void setCommitter(String committer) {
            this.committer = committer;
        }

        @Editable(name="QuickBuild User", order=20)
        @NotEmpty
        @ChoiceProvider(value="getAvailableUserNames")
        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        private static List<String> getAvailableUserNames() {
            UserManager userManager = Quickbuild.getInstance(UserManager.class);
            ArrayList<String> userNames = new ArrayList<String>();
            for (User each : userManager.getAll()) {
                userNames.add(each.getName());
            }
            return userNames;
        }

        @Override
        public int compareTo(Entry entry) {
            return this.getCommitter().compareTo(entry.getCommitter());
        }
    }
}

