/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.repository.proofcondition;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.setting.repository.proofcondition.ProofCondition;
import com.pmease.quickbuild.setting.repository.proofcondition.ProofConditionCriteria;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="If one of specified criterias is satisfied", order=70)
public class OrProofCondition
implements ProofCondition {
    private static final long serialVersionUID = 1L;
    private List<ProofConditionCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<ProofConditionCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<ProofConditionCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean satisfied(Repository<?> repository) {
        for (ProofConditionCriteria each : this.getCriterias()) {
            if (!each.getCriteria().satisfied(repository)) continue;
            return true;
        }
        return false;
    }
}

