/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.version;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.setting.configuration.version.VersionManager;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Use value of specified variable", order=20)
public class VariableVersionManager
extends VersionManager {
    private static final long serialVersionUID = 1L;
    private String variableName;

    @Editable(description="Specify name of the variable whose value will be used as build version. By specifying prompt setting of the variable, you can make QuickBuild asking user for build version when build is manually triggered.")
    @ChoiceProvider(value="getAvailableVariables")
    @NotEmpty
    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    private static List<String> getAvailableVariables() {
        ArrayList<String> available = new ArrayList<String>(Context.getConfiguration().findVariableNames());
        Collections.sort(available);
        return available;
    }

    @Override
    public String getNext() {
        VariableWrapper var = Context.get().getVar(this.getVariableName());
        if (var == null) {
            throw new QuickbuildException("Variable not found: " + this.getVariableName());
        }
        if (Context.isBackend()) {
            return var.getValue();
        }
        return null;
    }
}

