/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.version;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.configuration.version.VersionManager;
import com.pmease.quickbuild.util.StringUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Use specified version", order=10)
public class UseSpecifiedVersion
extends VersionManager {
    private static final long serialVersionUID = 1L;
    private String version;

    @Editable(description="Specify next build version here. Last digit of the version will be auto-increased if scripts are not embedded.")
    @NotEmpty
    @Scriptable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getNext() {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        if (!scriptEngine.interpolative(this.version)) {
            String version = this.getVersion();
            String reversedVersion = StringUtils.reverse((String)version);
            Matcher matcher = Pattern.compile("\\d+").matcher(reversedVersion);
            if (matcher.find()) {
                String digits = StringUtils.reverse((String)matcher.group());
                String increasedDigits = String.valueOf(Long.valueOf(digits) + 1L);
                increasedDigits = StringUtils.reverse((String)increasedDigits);
                reversedVersion = matcher.replaceFirst(increasedDigits);
            }
            this.setVersion(StringUtils.reverse((String)reversedVersion));
            return version;
        }
        return this.getVersion();
    }
}

