/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.promotion;

import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.FileDelivery;
import com.pmease.quickbuild.PromoteServer;
import com.pmease.quickbuild.PromotionSource;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.annotation.Sortable;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.rest.RestModule;
import com.pmease.quickbuild.setting.configuration.promotion.IfBuildIsSuccessful;
import com.pmease.quickbuild.setting.configuration.promotion.PromoteCondition;
import com.pmease.quickbuild.util.Single;
import com.pmease.quickbuild.validation.ErrorContext;
import com.pmease.quickbuild.validation.Validatable;
import com.pmease.quickbuild.variable.DoNotPrompt;
import com.pmease.quickbuild.variable.PromptSetting;
import com.pmease.quickbuild.variable.Variable;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScriptApi
public class Promotion
implements Serializable,
Validatable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Promotion.class);
    public static final String VARIABLE_PROMPT_BEAN_PREFIX = "PromoteVariablePromptBean";
    private String name;
    private PromoteCondition condition = new IfBuildIsSuccessful();
    private com.pmease.quickbuild.setting.configuration.promotion.PromoteServer server;
    private String configurationPath;
    private boolean autoPromote;
    private boolean promptConfVars;
    private List<Variable> variables = new ArrayList<Variable>();
    private List<com.pmease.quickbuild.setting.configuration.promotion.FileDelivery> deliveries = new ArrayList<com.pmease.quickbuild.setting.configuration.promotion.FileDelivery>();
    private transient Map<Long, Class<?>> variablePromptBeanClassCache;
    private transient Single<Configuration> dstConfigurationWrapper;

    @Editable(order=10, description="Specify name of the promotion, for example: <i>release</i>, <i>deploy to server1</i>")
    @NotEmpty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=50, name="Condition", description="This promotion will be available only if this condition is satisfied.")
    @NotNull
    @ScriptApi(value="Get promote condition.")
    public PromoteCondition getCondition() {
        return this.condition;
    }

    public void setCondition(PromoteCondition condition) {
        this.condition = condition;
    }

    @Editable(order=100, description="Check this if you want to promote builds of this configuration into another QuickBuild server. Configuration specified below will be considered to reside on the specified server if this option is checked.")
    @ScriptApi(value="Get the server to which builds of this configuration will be promoted to.")
    public com.pmease.quickbuild.setting.configuration.promotion.PromoteServer getServer() {
        return this.server;
    }

    public void setServer(com.pmease.quickbuild.setting.configuration.promotion.PromoteServer server) {
        this.server = server;
    }

    @Editable(order=200, name="Configuration", description="Specify path of the configuration where you want to promote builds of this configuration into.")
    @ConfigurationPath
    @NotEmpty
    @ScriptApi(value="Get path of the configuration to which builds of this configuration should be promoted to.")
    @Scriptable
    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    @Editable(order=250, description="If checked, build satisfying the promotion condition will be auto-promoted after build finishes.")
    public boolean isAutoPromote() {
        return this.autoPromote;
    }

    public void setAutoPromote(boolean autoPromote) {
        this.autoPromote = autoPromote;
    }

    @Editable(name="Prompt Configuration Variables", order=300, description="If checked, all promptable variables defined in and inherited by above configuration will be prompted together with promptable variables defined below when the promomtion is requested.")
    public boolean isPromptConfVars() {
        return this.promptConfVars;
    }

    public void setPromptConfVars(boolean promptConfVars) {
        this.promptConfVars = promptConfVars;
    }

    @Editable(order=500, description="Define variables to be used in promotion process. During a promotion process, variables will be searched in below order:<ul><li>Promotion variables defined here.</li><li>Variables defined in destination configuration and its ancestors.<li><li>Variables stored in the source build (displayed in variables tab of the build).</li></ul>")
    @Sortable
    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    @Editable(name="Files to Promote", order=600, description="Specify files to promote. Promoted files will be sent to workspace of the node running master step in destination configuration.")
    @ScriptApi(value="Get files to promote.")
    public List<com.pmease.quickbuild.setting.configuration.promotion.FileDelivery> getDeliveries() {
        return this.deliveries;
    }

    public void setDeliveries(List<com.pmease.quickbuild.setting.configuration.promotion.FileDelivery> deliveries) {
        this.deliveries = deliveries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getVariablePromptBeanClass(Build build) {
        Class variablePromptBeanClass = this.getVariablePromptBeanClassCache().get(build.getId());
        if (variablePromptBeanClass == null) {
            try {
                Configuration dstConfiguration;
                Context.push(build);
                StringBuffer buffer = new StringBuffer("groovy:");
                buffer.append("import com.pmease.quickbuild.annotation.*;\n");
                buffer.append("import javax.validation.constraints.*;\n");
                buffer.append("import org.hibernate.validator.constraints.*;\n");
                String className = "PromoteVariablePromptBean_" + build.getId() + "_" + new String(Hex.encodeHex((byte[])this.getName().getBytes()));
                buffer.append("class " + className + " {\n");
                int index = 0;
                for (Variable var : this.getVariables()) {
                    if (!(var.getPromptSetting() instanceof DoNotPrompt)) {
                        boolean prompt;
                        if (var.getPromptSetting().getCondition() != null) {
                            Map<String, Object> context = Context.buildEvalContext(this, null);
                            prompt = (Boolean)ScriptEngine.instance.evaluate(var.getPromptSetting().getCondition(), context);
                        } else {
                            prompt = true;
                        }
                        if (prompt) {
                            buffer.append(var.getPromptSetting().getPropertyDef(var.getName(), var.getPromptSetting().getOrder() * 100 + index));
                        }
                    }
                    ++index;
                }
                if (this.isPromptConfVars() && (dstConfiguration = this.getDstConfiguration()) != null) {
                    try {
                        Context.push(dstConfiguration);
                        for (Variable var : dstConfiguration.findVariables()) {
                            if (!Variable.contains(this.getVariables(), var) && !(var.getPromptSetting() instanceof DoNotPrompt)) {
                                boolean prompt;
                                PromptSetting promptSetting = (PromptSetting)ScriptEngine.instance.installInterpolator(var.getPromptSetting());
                                if (promptSetting.getCondition() != null) {
                                    Map<String, Object> context = Context.buildEvalContext(this, null);
                                    prompt = (Boolean)ScriptEngine.instance.evaluate(promptSetting.getCondition(), context);
                                } else {
                                    prompt = true;
                                }
                                if (prompt) {
                                    buffer.append(promptSetting.getPropertyDef(var.getName(), promptSetting.getOrder() * 100 + index));
                                }
                            }
                            ++index;
                        }
                    }
                    finally {
                        Context.pop();
                    }
                }
                buffer.append("}\nreturn " + className + ";");
                logger.debug("Constucted promote option bean:\n" + buffer.toString());
                variablePromptBeanClass = (Class)ScriptEngine.instance.evaluate(buffer.toString(), Context.buildEvalContext(null, null));
                this.getVariablePromptBeanClassCache().put(build.getId(), variablePromptBeanClass);
            }
            finally {
                Context.pop();
            }
        }
        return variablePromptBeanClass;
    }

    @ScriptApi(value="Get variable of specified name. Null if not found.")
    public Variable getVar(String varName) {
        for (Variable var : this.getVariables()) {
            if (!var.getName().equals(varName)) continue;
            return var;
        }
        if (this.isPromptConfVars() && this.getDstConfiguration() != null) {
            for (Variable var : this.getDstConfiguration().findVariables()) {
                if (!var.getName().equals(varName)) continue;
                ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
                Variable newVar = (Variable)scriptEngine.installInterpolator(var);
                newVar.setConfigurationId(this.getDstConfiguration().getId());
                return newVar;
            }
        }
        return null;
    }

    public static boolean contains(Collection<Promotion> promotions, Promotion promotion) {
        for (Promotion each : promotions) {
            if (!each.getName().equals(promotion.getName())) continue;
            return true;
        }
        return false;
    }

    public static Long getBuildId(String variablePromptBeanClassName) {
        String suffix = StringUtils.substringAfter((String)variablePromptBeanClassName, (String)"_");
        return Long.valueOf(StringUtils.substringBefore((String)suffix, (String)"_"));
    }

    public static String getName(String variablePromptBeanClassName) {
        String suffix = StringUtils.substringAfter((String)variablePromptBeanClassName, (String)"_");
        try {
            return new String(Hex.decodeHex((char[])StringUtils.substringAfter((String)suffix, (String)"_").toCharArray()));
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    @ScriptApi(value="Promote specified build.")
    public void promote(Build build) {
        this.promote(build, new HashMap<String, String>());
    }

    @ScriptApi(value="Promote specified build with specified variables.")
    public Configuration promote(Build build, Map<String, String> promptVarValues) {
        return this.promote(build, promptVarValues, false);
    }

    @ScriptApi(value="Promote specified build with specified variables. The third param tells QB whether this is an automated promotion.")
    public Configuration promote(Build build, Map<String, String> promptVarValues, boolean autoPromote) {
        for (Variable var : this.getVariables()) {
            if (!promptVarValues.containsKey(var.getName())) continue;
            var.setValue(promptVarValues.get(var.getName()));
        }
        PromotionSource promotionSource = new PromotionSource();
        promotionSource.setBuildId(build.getId());
        promotionSource.setPromotionName(this.getName());
        promotionSource.setAutomated(autoPromote);
        for (com.pmease.quickbuild.setting.configuration.promotion.FileDelivery each : this.getDeliveries()) {
            FileDelivery delivery = new FileDelivery();
            delivery.setDestPath(each.getDestPath());
            delivery.setFilePatterns(each.getFilePatterns());
            delivery.setSrcPath(each.getSrcPath());
            promotionSource.getDeliveries().add(delivery);
        }
        HashMap<String, String> varValues = new HashMap<String, String>();
        for (Variable var : this.getVariables()) {
            varValues.put(var.getName(), var.getValue());
        }
        if (promptVarValues != null) {
            varValues.putAll(promptVarValues);
        }
        BuildRequest request = new BuildRequest();
        request.setPromotionSource(promotionSource);
        request.setRespectBuildCondition(false);
        request.getVariables().putAll(varValues);
        if (this.getServer() != null) {
            promotionSource.setServer(new PromoteServer());
            promotionSource.getServer().setUrl(Quickbuild.getInstance().getUrl());
            promotionSource.getServer().setUserName(this.getServer().getUserName());
            promotionSource.getServer().setPassword(this.getServer().getPassword());
            WebResource resource = RestModule.resource(this.getServer().getUrl(), "rest/ids", this.getServer().getUserName(), this.getServer().getPassword());
            ClientResponse response = (ClientResponse)resource.queryParam("configuration_path", this.getConfigurationPath()).get(ClientResponse.class);
            if (response.getStatus() == 204) {
                throw new QuickbuildException("Promotion destination '" + this.getConfigurationPath() + "' is not found at server '" + this.getServer().getUrl() + "'.");
            }
            if (response.getStatus() != 200) {
                throw new QuickbuildException("Error querying id of promotion destination '" + this.getConfigurationPath() + "' at server '" + this.getServer().getUrl() + "': " + (String)response.getEntity(String.class));
            }
            request.setConfigurationId((Long)response.getEntity(Long.class));
            resource = RestModule.resource(this.getServer().getUrl(), "rest/build_requests", this.getServer().getUserName(), this.getServer().getPassword());
            resource.post((Object)request);
            return null;
        }
        Configuration configuration = ConfigurationManager.instance.get(this.getConfigurationPath());
        if (configuration == null) {
            throw new QuickbuildException("Can not find promotion destination '" + this.getConfigurationPath() + "'.");
        }
        request.setConfigurationId(configuration.getId());
        Quickbuild.getInstance(BuildEngine.class).requestBuild(Context.getUser(), false, request);
        AuditManager.instance.audit(configuration, "Promotion was requested from " + build.getConfiguration() + ":" + build.getVersion() + ".");
        return configuration;
    }

    private Configuration getDstConfiguration() {
        if (this.dstConfigurationWrapper == null) {
            Configuration dstConfiguration;
            if (this.getServer() == null) {
                ConfigurationManager configurationManager = Quickbuild.getInstance(ConfigurationManager.class);
                dstConfiguration = configurationManager.get(this.getConfigurationPath());
            } else {
                dstConfiguration = null;
            }
            this.dstConfigurationWrapper = new Single<Object>(dstConfiguration);
        }
        return this.dstConfigurationWrapper.getValue();
    }

    @Override
    public void validate(Set<String> properties, ErrorContext errorContext) {
        if (this.getServer() != null && this.isPromptConfVars()) {
            errorContext.setError("promptConfVars", "This option can only be set when destination configuration resides on current server.");
        }
    }

    public Map<Long, Class<?>> getVariablePromptBeanClassCache() {
        if (this.variablePromptBeanClassCache == null) {
            this.variablePromptBeanClassCache = new HashMap();
        }
        return this.variablePromptBeanClassCache;
    }
}

