/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.promotion;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Password;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import java.io.Serializable;
import org.hibernate.validator.constraints.NotEmpty;

public class PromoteServer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String url;
    private String userName;
    private String password;
    private Promotion promotion;

    @Editable(order=100, description="Specify server url. For example: <em>http://server-host-name:8810</em>")
    @Scriptable
    @NotEmpty
    @ScriptApi(value="Get url of the server.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Editable(order=200, description="Specify user name to login to the server. Server will be accessed anonymously if user name is not specified.<br><b>NOTE:</b> Besides remote server, current server should also have an account with the same user and password with permissions to access artifacts of the build to be promoted. This is because that the promotion process runs at remote server needs to come back to this server to download the promoted artifacts.")
    @Scriptable
    @ScriptApi(value="Get user name to login to the user. Null for anonymous access.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Editable(order=300, description="Specify password for above user.")
    @Scriptable
    @Password
    @ScriptApi(value="Get password to login to the server.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @ScriptApi(value="Get associated promotion object.")
    public Promotion getPromotion() {
        return this.promotion;
    }

    public PromoteServer(Promotion promotion) {
        this.promotion = promotion;
    }
}

