/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.promotion;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.setting.configuration.promotion.PromoteCondition;
import com.pmease.quickbuild.setting.configuration.promotion.PromoteConditionCriteria;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="If one of specified criterias is satisfied", order=70)
public class OrPromoteCondition
implements PromoteCondition {
    private static final long serialVersionUID = 1L;
    private List<PromoteConditionCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<PromoteConditionCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<PromoteConditionCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean satisfied(Promotion promotion) {
        for (PromoteConditionCriteria each : this.getCriterias()) {
            if (!each.getCriteria().satisfied(promotion)) continue;
            return true;
        }
        return false;
    }
}

