/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.promotion;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.Membership;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.persistence.SessionManager;
import com.pmease.quickbuild.setting.configuration.promotion.PromoteCondition;
import com.pmease.quickbuild.setting.configuration.promotion.Promotion;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.Size;
import org.apache.commons.collections.CollectionUtils;

@Editable(name="If login user belongs to one of specified groups", order=47)
public class GroupPromoteCondition
implements PromoteCondition {
    private static final long serialVersionUID = 1L;
    private List<String> groupNames = new ArrayList<String>();

    @Editable(name="Groups")
    @Size(min=1, max=10000)
    @ChoiceProvider(value="getAvailableGroups")
    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public void setGroupNames(List<String> groupNames) {
        this.groupNames = groupNames;
    }

    private static List<String> getAvailableGroups() {
        return Quickbuild.getInstance(GroupManager.class).getGroupNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean satisfied(Promotion promotion) {
        ArrayList<String> belongGroups = new ArrayList<String>();
        User user = Context.getUser();
        if (user != null) {
            SessionManager.openSession();
            try {
                User reloaded = (User)UserManager.instance.load(user.getId());
                for (Membership membership : reloaded.getMemberships()) {
                    belongGroups.add(membership.getGroup().getName());
                }
            }
            finally {
                SessionManager.closeSession();
            }
        } else {
            belongGroups.add("anonymous");
        }
        return CollectionUtils.containsAny(belongGroups, this.getGroupNames());
    }
}

