/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.promotion;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Expressions;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import java.io.Serializable;
import org.hibernate.validator.constraints.NotEmpty;

@ScriptApi
public class FileDelivery
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String srcPath = "artifacts";
    private String filePatterns;
    private String destPath;

    @Editable(order=100, name="Source Path", description="Specify a path under publish directory of the source build from which to retrieve files for promotion.")
    @Expressions(value={"artifacts", "artifacts"})
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get source path of files to promote.")
    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    @Editable(order=200, name="Files To Promote", description="Specify patterns of files that need to be promoted. Patterns will be matched under the <b>source path</b> specified above. Matched files will be copied to the <b>destination path</b> specified below. The directory structure will be preserved during copy.<br><strong>NOTE:</strong> refer to <a href=\"$docroot/File+Pattern+Reference\">the file patterns reference</a> for details of the file patterns.")
    @Expressions(value={"all files (recursively)", "**", "all files (non-recursively)", "*"})
    @NotEmpty
    @Scriptable
    @ScriptApi(value="Get patterns of files to promote.")
    public String getFilePatterns() {
        return this.filePatterns;
    }

    public void setFilePatterns(String filePatterns) {
        this.filePatterns = filePatterns;
    }

    @Editable(order=300, name="Destination Path", description="Specify destination path of promoted files. This path is relative to workspace directory of the node running master step in destination configuration. If left empty, the workspace directory itself will be assumed.")
    @Scriptable
    @ScriptApi(value="Get destination path to put promoted files.")
    public String getDestPath() {
        return this.destPath;
    }

    public void setDestPath(String destPath) {
        this.destPath = destPath;
    }
}

