/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.notification;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.setting.configuration.notification.Notification;
import com.pmease.quickbuild.setting.configuration.notification.NotifyCondition;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="If specified variable evaluates to true", order=67)
public class VariableNotifyCondition
implements NotifyCondition {
    private static final long serialVersionUID = 1L;
    private String variable;

    @Editable(description="Specify the variable to evaulate. Evaluation will be true if value of specified variable equals (case insensitive) to \"true\", \"t\", \"yes\", or \"y\".")
    @ChoiceProvider(value="getAvailableVariables")
    @NotEmpty
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    private static List<String> getAvailableVariables() {
        ArrayList<String> varNames = new ArrayList<String>(Context.getConfiguration().findVariableNames());
        Collections.sort(varNames);
        return varNames;
    }

    @Override
    public boolean satisfied(Notification notification) {
        VariableWrapper var = Context.get().getVar(this.getVariable());
        if (var == null) {
            throw new QuickbuildException("Variable not found: " + this.getVariable());
        }
        return var.asBoolean();
    }
}

