/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.notification;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.setting.configuration.notification.Notification;
import com.pmease.quickbuild.setting.configuration.notification.NotifyCondition;
import com.pmease.quickbuild.setting.configuration.notification.NotifyConditionCriteria;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="If one of specified criterias is satisfied", order=90)
public class OrNotifyCondition
implements NotifyCondition {
    private static final long serialVersionUID = 1L;
    private List<NotifyConditionCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<NotifyConditionCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<NotifyConditionCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean satisfied(Notification notification) {
        for (NotifyConditionCriteria each : this.getCriterias()) {
            if (!each.getCriteria().satisfied(notification)) continue;
            return true;
        }
        return false;
    }
}

