/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.notification;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.extensionpoint.Notifier;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.setting.configuration.notification.IfBuildIsFailed;
import com.pmease.quickbuild.setting.configuration.notification.NotifyCondition;
import com.pmease.quickbuild.util.EasySet;
import com.pmease.quickbuild.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@ScriptApi(value="This class defines who should receive the notification, when the notification should be sent, and via which notifier.")
public class Notification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TRIGGER = "<trigger>";
    public static final String COMMITTERS_SINCE_PREVIOUS = "<committers since previous build>";
    public static final String COMMITTERS_SINCE_PREVIOUS_SUCCESSFUL = "<committers since previous successful>";
    private Set<String> receivers = EasySet.create("<committers since previous build>");
    private String notifier;
    private NotifyCondition condition = new IfBuildIsFailed();

    @Editable(order=100, name="Receivers", description="Specify who should be forced to receive the notification even if not subscribed. Receiver enclosed within square brackets represents a group, and if selected, all users in the group will receive the notification. The user <b>&lt;trigger&gt;</b> stands for the user who triggered the build, and <b>&lt;committers&gt;</b> stands for all found users in change sets of the build.")
    @ChoiceProvider(value="getAvailableReceivers")
    @Size(min=1, max=10000)
    @ScriptApi(value="Get set of receiver names for this notification.")
    public Set<String> getReceivers() {
        return this.receivers;
    }

    public void setReceivers(Set<String> receivers) {
        this.receivers = receivers;
    }

    @Editable(order=150, name="Notify Through", description="Select one or more notifiers through which the build notification will be sent if notify conditions are satisfied.")
    @ChoiceProvider(value="getAvailableNotifiers")
    @NotNull
    public String getNotifier() {
        return this.notifier;
    }

    public void setNotifier(String notifier) {
        this.notifier = notifier;
    }

    private static List<String> getAvailableNotifiers() {
        ArrayList<String> notifiers = new ArrayList<String>();
        for (Notifier notifier : Quickbuild.getInstance(PluginManager.class).getExtensions(Notifier.class)) {
            notifiers.addAll(notifier.getChannelNames());
        }
        return notifiers;
    }

    @Editable(order=200, name="Condition", description="Specify the condition when this notification will be sent.")
    @NotNull
    @ScriptApi(value="Get notify condition.")
    public NotifyCondition getCondition() {
        return this.condition;
    }

    public void setCondition(NotifyCondition condition) {
        this.condition = condition;
    }

    private static List<String> getAvailableReceivers() {
        ArrayList<String> receivers = new ArrayList<String>();
        receivers.add(TRIGGER);
        receivers.add(COMMITTERS_SINCE_PREVIOUS);
        receivers.add(COMMITTERS_SINCE_PREVIOUS_SUCCESSFUL);
        ArrayList<String> names = new ArrayList<String>();
        for (Group group : Quickbuild.getInstance(GroupManager.class).getAll()) {
            names.add("[" + group.getName() + "]");
        }
        Collections.sort(names);
        receivers.addAll(names);
        names.clear();
        for (User user : Quickbuild.getInstance(UserManager.class).getAll()) {
            names.add(user.getName());
        }
        Collections.sort(names);
        receivers.addAll(names);
        return receivers;
    }

    public Key getKey() {
        return new Key(this.getReceivers(), this.getNotifier());
    }

    public static boolean contains(Collection<Notification> notifications, Notification notification) {
        for (Notification each : notifications) {
            if (!each.getKey().equals(notification.getKey())) continue;
            return true;
        }
        return false;
    }

    public static class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Set<String> receivers;
        private String notifier;

        public Key(Set<String> receivers, String notifier) {
            this.receivers = receivers;
            this.notifier = notifier;
        }

        public Set<String> getReceivers() {
            return this.receivers;
        }

        public String getNotifier() {
            return this.notifier;
        }

        public String toString() {
            return StringUtils.join(this.receivers) + "/" + this.notifier;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Key)) {
                return false;
            }
            if (this == other) {
                return true;
            }
            Key otherKey = (Key)other;
            return new EqualsBuilder().append(this.getReceivers(), otherKey.getReceivers()).append((Object)this.getNotifier(), (Object)otherKey.getNotifier()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.getReceivers()).append((Object)this.getNotifier()).toHashCode();
        }
    }
}

