/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.nodeassignment;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.configuration.nodeassignment.NodeAssignment;
import com.pmease.quickbuild.stepsupport.Step;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="On node with address equals to value of specified variable", order=195)
@Current(value=Step.class)
public class VariableNodeAssignment
implements NodeAssignment {
    private static final long serialVersionUID = 1L;
    private String variable;

    @Editable(description="Specify the variable whose value will be used as node address.")
    @ChoiceProvider(value="getAvailableVariables")
    @NotEmpty
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    private static List<String> getAvailableVariables() {
        ArrayList<String> varNames = new ArrayList<String>(Context.getConfiguration().findVariableNames());
        Collections.sort(varNames);
        return varNames;
    }

    @Override
    public boolean matches(GridNode node) {
        VariableWrapper var = Context.get().getVar(this.getVariable());
        if (var == null) {
            throw new QuickbuildException("Variable not found: " + this.getVariable());
        }
        return node.getAddress().equals(var.getValue());
    }
}

