/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.nodeassignment;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.setting.configuration.nodeassignment.NodeAssignment;
import com.pmease.quickbuild.setting.configuration.nodeassignment.NodeAssignmentCriteria;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="Nodes matching one of specified criterias", order=220)
public class OrAssignment
implements NodeAssignment {
    private static final long serialVersionUID = 1L;
    private List<NodeAssignmentCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<NodeAssignmentCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<NodeAssignmentCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean matches(GridNode node) {
        for (NodeAssignmentCriteria each : this.getCriterias()) {
            if (!each.getCriteria().matches(node)) continue;
            return true;
        }
        return false;
    }
}

