/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.loglevel;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.log.Log;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.setting.configuration.loglevel.BuildLogLevel;
import com.pmease.quickbuild.variable.VariableWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Get Log Level from Variable", order=100)
public class VariableLogLevel
implements BuildLogLevel {
    private static final long serialVersionUID = 1L;
    private String variableName;

    @Editable(description="Specify name of the variable whose value will be used as log level. The variable value should be one of <em>Error, Warn, Info, Debug, Verbose (case insensitive)</em>. By specifying prompt setting of the variable, you can make QuickBuild asking user for log level when build is manually triggered.")
    @ChoiceProvider(value="getAvailableVariables")
    @NotEmpty
    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    private static List<String> getAvailableVariables() {
        ArrayList<String> available = new ArrayList<String>(Context.getConfiguration().findVariableNames());
        Collections.sort(available);
        return available;
    }

    @Override
    public Log.LogLevel getLevel(Build build) {
        VariableWrapper var = build.getVar(this.getVariableName());
        if (var == null) {
            throw new QuickbuildException("Variable not found: " + this.getVariableName());
        }
        return Log.LogLevel.valueOf(var.getValue().toUpperCase());
    }
}

