/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.customcolumn.build;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.setting.configuration.customcolumn.build.ValueProvider;
import com.pmease.quickbuild.variable.VariableAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Use value of specified variable", order=100)
public class VariableValueProvider
implements ValueProvider {
    private String variableName;

    @Editable
    @NotEmpty
    @ChoiceProvider(value="getAvailableVariables")
    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue(Build build) {
        Context.push(build);
        try {
            String string = new VariableAccessor().getValue(this.getVariableName());
            return string;
        }
        finally {
            Context.pop();
        }
    }

    private static List<String> getAvailableVariables() {
        ArrayList<String> available = new ArrayList<String>(Context.getConfiguration().findVariableNames());
        Collections.sort(available);
        return available;
    }
}

