/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.buildcondition;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ScriptApi;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.dependency.QuickbuildRepository;
import com.pmease.quickbuild.repositorysupport.Repository;
import com.pmease.quickbuild.setting.configuration.buildcondition.BuildCondition;

public abstract class ChangeBasedBuildCondition
implements BuildCondition {
    private static final long serialVersionUID = 1L;
    private String pathPatterns;

    @Editable(name="Include/Exclude Path Patterns", description="Optionally include or exclude repository paths for change detection. Refer to <a href=\"$docroot/Repository+Path\">the repository path reference</a> for format of repository path for different SCM systems. <a href=\"$docroot/File+Pattern+Reference\">Patterns</a> can be used in the repository path to match a set of files. Taking Subversion for example, the path patterns \"/productA/**, -/productA/docs/**\" tells QuickBuild that repositories are considered to be changed if commits found recursively under path \"/productA\" but not under \"/productA/docs\"")
    @Scriptable
    @ScriptApi(value="Get defined path patterns.")
    public String getPathPatterns() {
        return this.pathPatterns;
    }

    public void setPathPatterns(String pathPatterns) {
        this.pathPatterns = pathPatterns;
    }

    protected boolean isChanged() {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        String pathPatterns = scriptEngine.interpolate(this.getPathPatterns(), Context.buildEvalContext(this, null));
        for (Repository<?> repository : Context.getConfiguration().getReferencedRepositories()) {
            if (!(!(repository instanceof QuickbuildRepository) && pathPatterns != null ? repository.isChanged(pathPatterns) : repository.isChanged())) continue;
            return true;
        }
        return false;
    }
}

