/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.buildcondition;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.buildcondition.BuildCondition;
import com.pmease.quickbuild.setting.configuration.buildcondition.BuildConditionCriteria;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="If all specified criterias are satisfied", order=600)
public class AndBuildCondition
implements BuildCondition {
    private static final long serialVersionUID = 1L;
    private List<BuildConditionCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<BuildConditionCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<BuildConditionCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean satisfied(Configuration current) {
        for (BuildConditionCriteria each : this.getCriterias()) {
            if (each.getCriteria().satisfied(Context.getConfiguration())) continue;
            return false;
        }
        return true;
    }
}

