/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.artifactstorage;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.setting.configuration.artifactstorage.ArtifactStorage;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

@Editable(name="Store artifacts on server", order=100)
public class ServerArtifactStorage
extends ArtifactStorage {
    private static final long serialVersionUID = 1L;

    @Override
    public void download(Build build, String artifactFile, File destFile) {
        GridNode serverNode = Grid.instance.getServerNode();
        String buildPublishDir = serverNode.getNodeService().getBuildPublishDir(build.getId());
        Grid.instance.transferFile(serverNode, buildPublishDir + "/" + artifactFile, Grid.instance.getLocalNode(), destFile.getAbsolutePath(), null, null);
    }

    @Override
    public void upload(File srcFile, Build build, String artifactFile) {
        GridNode serverNode = Grid.instance.getServerNode();
        String buildPublishDir = serverNode.getNodeService().getBuildPublishDir(build.getId());
        Grid.instance.transferFile(Grid.instance.getLocalNode(), srcFile.getAbsolutePath(), serverNode, buildPublishDir + "/" + artifactFile, null, null);
    }

    @Override
    public String getUrl(Build build, String artifactFile) {
        return "/download/" + build.getLatestAwareId() + "/" + artifactFile;
    }

    @Override
    public void cleanup(Build build, String artifactFile) {
        FileUtils.deleteFile(new File(build.getPublishDir(), artifactFile));
    }

    @Override
    public ArtifactStorage.BatchSupport getBatchSupport() {
        return new ArtifactStorage.BatchSupport(){

            @Override
            public String getUrl(Build build, String artifactDir, String artifactPatterns) {
                try {
                    return "/batch_download?build_id=" + build.getLatestAwareId() + "&" + "src_path" + "=" + URLEncoder.encode(artifactDir, "UTF-8") + "&" + "file_patterns" + "=" + URLEncoder.encode(artifactPatterns, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void download(Build build, String artifactDir, String artifactPatterns, File destDir) {
                GridNode serverNode = Grid.instance.getServerNode();
                String buildPublishDir = serverNode.getNodeService().getBuildPublishDir(build.getId());
                Grid.instance.transferFiles(serverNode, buildPublishDir + "/" + artifactDir, artifactPatterns, Grid.instance.getLocalNode(), destDir.getAbsolutePath(), false, null, null);
            }

            @Override
            public void upload(File srcDir, String srcPatterns, Build build, String artifactDir) {
                GridNode serverNode = Grid.instance.getServerNode();
                String buildPublishDir = serverNode.getNodeService().getBuildPublishDir(build.getId());
                Grid.instance.transferFiles(Grid.instance.getLocalNode(), srcDir.getAbsolutePath(), srcPatterns, serverNode, buildPublishDir + "/" + artifactDir, false, null, null);
            }

            @Override
            public void cleanup(Build build, String artifactDir) {
                if (artifactDir != null) {
                    FileUtils.deleteDir(new File(build.getPublishDir(), artifactDir));
                } else {
                    FileUtils.deleteDir(build.getPublishDir());
                }
            }
        };
    }
}

