/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.artifactstorage;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ImplementationProvider;
import com.pmease.quickbuild.extensionpoint.ArtifactStorageProvider;
import com.pmease.quickbuild.extensionpoint.support.TypeInstance;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.util.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@ImplementationProvider(method="getImplementations")
public abstract class ArtifactStorage
extends TypeInstance {
    private static final long serialVersionUID = 1L;

    public abstract void download(Build var1, String var2, File var3);

    public abstract void upload(File var1, Build var2, String var3);

    public abstract void cleanup(Build var1, String var2);

    public abstract String getUrl(Build var1, String var2);

    public abstract BatchSupport getBatchSupport();

    private static List<Class<? extends ArtifactStorage>> getImplementations() {
        ArrayList<Class<? extends ArtifactStorage>> implementations = new ArrayList<Class<? extends ArtifactStorage>>();
        PluginManager pluginManager = Quickbuild.getInstance(PluginManager.class);
        for (ArtifactStorageProvider provider : pluginManager.getExtensions(ArtifactStorageProvider.class)) {
            Class<? extends ArtifactStorage> artifactStorageClass = provider.getArtifactStorageClass();
            if (artifactStorageClass == null) continue;
            implementations.add(artifactStorageClass);
        }
        return implementations;
    }

    public void cleanupArtifacts(Build build, @Nullable String artifactDir) {
        try {
            if (this.getBatchSupport() != null) {
                this.getBatchSupport().cleanup(build, artifactDir);
            } else if (artifactDir != null) {
                for (File file : FileUtils.listFiles(new File(build.getPublishDir(), artifactDir), "**")) {
                    if (!file.isFile()) continue;
                    String artifactFile = FileUtils.getRelativePath(file.getAbsolutePath(), build.getPublishDir().getAbsolutePath().substring(1));
                    this.cleanup(build, artifactFile);
                }
            } else {
                for (File file : FileUtils.listFiles(build.getPublishDir(), "**")) {
                    if (!file.isFile()) continue;
                    String artifactFile = FileUtils.getRelativePath(file.getAbsolutePath(), build.getPublishDir().getAbsolutePath().substring(1));
                    this.cleanup(build, artifactFile);
                }
            }
        }
        catch (Exception e) {
            Context.getLogger().warn("Unable to cleanup artifacts from artifact storage.", (Throwable)e);
        }
        if (artifactDir != null) {
            FileUtils.deleteDir(new File(build.getPublishDir(), artifactDir));
        } else {
            FileUtils.deleteDir(build.getPublishDir());
        }
    }

    public static interface BatchSupport {
        public void download(Build var1, String var2, String var3, File var4);

        public void upload(File var1, String var2, Build var3, String var4);

        public void cleanup(Build var1, String var2);

        public String getUrl(Build var1, String var2, String var3);
    }
}

