/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.artifactcleanup;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Numeric;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.setting.configuration.artifactcleanup.ArtifactCleanupStrategy;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

@Editable(name="Reserve artifacts for specified number of days", order=100)
public class ReserveArtifactsByDays
implements ArtifactCleanupStrategy {
    private static final long serialVersionUID = 1L;
    private String days = "30";

    @Editable(name="Days", description="Specify how many days to reserve artifacts. Use 0 to retain all artifacts.")
    @Scriptable
    @Numeric
    @Range(min=0L)
    @NotEmpty
    public String getDays() {
        return this.days;
    }

    public void setDays(String days) {
        this.days = days;
    }

    @Override
    public int getCount() {
        return Integer.parseInt(this.getDays());
    }
}

