/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.aggregation.BuildMatcher;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Aggregate builds with specified variable", order=34)
public class WithSpecifiedVariableMatcher
implements BuildMatcher {
    private static final long serialVersionUID = 1L;
    private String varName;
    private String varValue;

    @Editable(name="Variable Name", description="Specify name of the variable.")
    @Scriptable
    @NotEmpty
    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    @Editable(name="Variable Value", description="Specify value of the variable.")
    @Scriptable
    @NotEmpty
    public String getVarValue() {
        return this.varValue;
    }

    public void setVarValue(String varValue) {
        this.varValue = varValue;
    }

    @Override
    public boolean matches(Configuration configuration, Build build) {
        return this.getVarValue().equals(build.getVarValue(this.getVarName()));
    }
}

