/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.aggregation;

import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.annotation.ConfigurationPath;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.aggregation.BuildMatcher;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Aggregate builds under specified tree", order=31)
public class UnderSpecifiedTreeMatcher
implements BuildMatcher {
    private static final long serialVersionUID = 1L;
    private String treeRoot;
    private boolean includeRoot;

    @Editable(order=100, description="Specify root of the configuration tree.")
    @Scriptable
    @ConfigurationPath
    @NotEmpty
    public String getTreeRoot() {
        return this.treeRoot;
    }

    public void setTreeRoot(String treeRoot) {
        this.treeRoot = treeRoot;
    }

    @Editable(order=200, description="Whether or not to aggregate builds of the tree root configuration itself.")
    public boolean isIncludeRoot() {
        return this.includeRoot;
    }

    public void setIncludeRoot(boolean includeRoot) {
        this.includeRoot = includeRoot;
    }

    @Override
    public boolean matches(Configuration configuration, Build build) {
        Configuration treeRoot = ConfigurationManager.instance.get(this.getTreeRoot());
        if (treeRoot == null) {
            throw new QuickbuildException("Can not find configuration '" + this.getTreeRoot() + "'.");
        }
        if (this.isIncludeRoot()) {
            return build.getConfiguration().getInheritDistance(treeRoot) != -1;
        }
        return build.getConfiguration().getInheritDistance(treeRoot) > 0;
    }
}

