/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.aggregation;

import com.pmease.quickbuild.annotation.ConfigurationPaths;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Scriptable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.aggregation.BuildMatcher;
import com.pmease.quickbuild.util.StringUtils;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Aggregate builds of specified child configurations", order=33)
public class SpecifiedChildrenMatcher
implements BuildMatcher {
    private static final long serialVersionUID = 1L;
    private String configurationPaths;

    @Editable(description="Specify paths of the configurations. Multiple paths need to be separated with comma or new line character.")
    @Scriptable
    @ConfigurationPaths
    @NotEmpty
    public String getConfigurationPaths() {
        return this.configurationPaths;
    }

    public void setConfigurationPaths(String configurationPaths) {
        this.configurationPaths = configurationPaths;
    }

    @Override
    public boolean matches(Configuration configuration, Build build) {
        return StringUtils.splitAndTrim(this.getConfigurationPaths()).contains(build.getConfiguration().getPathName());
    }
}

