/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.aggregation;

import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.aggregationsupport.Aggregation;
import com.pmease.quickbuild.annotation.Current;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.Script;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.aggregation.BuildMatcher;
import com.pmease.quickbuild.util.EasyMap;
import java.util.Map;
import org.hibernate.validator.constraints.NotEmpty;

@Editable(name="Aggregate if specified script evaluates to true", order=50)
@Current(value=Aggregation.class)
public class ScriptMatcher
implements BuildMatcher {
    private static final long serialVersionUID = 1L;
    private String script;

    @Editable(description="In this script, the \"build\" object stands for the build to be aggregated, and \"configuration\" stands for current configuration.")
    @Script
    @NotEmpty
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public boolean matches(Configuration configuration, Build build) {
        ScriptEngine scriptEngine = Quickbuild.getInstance(ScriptEngine.class);
        Map<String, Object> context = Context.buildEvalContext(configuration, EasyMap.create("configuration", configuration, "build", build));
        return (Boolean)scriptEngine.evaluate(scriptEngine.interpolate(this.getScript(), context), context);
    }
}

