/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.setting.configuration.aggregation;

import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.model.Build;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.setting.configuration.aggregation.BuildMatcher;
import com.pmease.quickbuild.setting.configuration.aggregation.ChildMatcherCriteria;
import java.util.List;
import javax.validation.constraints.Size;

@Editable(name="Aggregate if build matches all specified criterias", order=60)
public class AndMatcher
implements BuildMatcher {
    private static final long serialVersionUID = 1L;
    private List<ChildMatcherCriteria> criterias;

    @Editable
    @Size(min=2, max=100)
    public List<ChildMatcherCriteria> getCriterias() {
        return this.criterias;
    }

    public void setCriterias(List<ChildMatcherCriteria> criterias) {
        this.criterias = criterias;
    }

    @Override
    public boolean matches(Configuration configuration, Build build) {
        for (ChildMatcherCriteria each : this.getCriterias()) {
            if (each.getCriteria().matches(configuration, build)) continue;
            return false;
        }
        return true;
    }
}

