/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.security;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.AuthenticationException;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.ScriptEngine;
import com.pmease.quickbuild.bootstrap.Bootstrap;
import com.pmease.quickbuild.entitymanager.MembershipManager;
import com.pmease.quickbuild.entitymanager.SettingManager;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.model.Authorization;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.model.Group;
import com.pmease.quickbuild.model.PermissionSet;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.AuthenticationResult;
import com.pmease.quickbuild.security.Authenticator;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.setting.system.SecuritySetting;
import com.pmease.quickbuild.setting.system.TrustUserNameInHttpHeader;
import com.pmease.quickbuild.util.CookieUtils;
import com.pmease.quickbuild.util.EasyMap;
import com.pmease.quickbuild.util.ExceptionUtils;
import com.pmease.quickbuild.util.Pair;
import com.pmease.quickbuild.util.StringUtils;
import com.pmease.quickbuild.validation.validator.NameValidator;
import com.pmease.quickbuild.web.MainServlet;
import com.pmease.quickbuild.web.WebSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityHelper {
    private static final Logger logger = LoggerFactory.getLogger(SecurityHelper.class);
    private static final String COOKIE_USERNAME = "QUICKBUILD_USER_" + (Bootstrap.getPort() != 0 ? Bootstrap.getPort() : Bootstrap.getSSLPort());
    private static final String COOKIE_PASSWORD = "QUICKBUILD_PASSWORD_" + (Bootstrap.getPort() != 0 ? Bootstrap.getPort() : Bootstrap.getSSLPort());

    public static boolean isAdmin(User user) {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        if (user == null) {
            Group anonymousGroup = cacheManager.getGroup("anonymous");
            return anonymousGroup != null && anonymousGroup.isAdmin();
        }
        if (user.isRoot()) {
            return true;
        }
        for (Group each : cacheManager.getGroups(user.getId())) {
            if (!each.isAdmin()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdmin() {
        return SecurityHelper.isAdmin(Context.getUser());
    }

    public static boolean isAgentAllowed() {
        return SecurityHelper.isAgentAllowed(Context.getUser());
    }

    public static boolean isEditSettingAllowed(Configuration configuration) {
        return SecurityHelper.hasPermission(configuration, ConfigurationPermission.EDIT_SETTINGS.name());
    }

    public static boolean isEditSettingAllowed() {
        return SecurityHelper.isEditSettingAllowed(Context.getConfiguration());
    }

    public static boolean isAgentAllowed(User user) {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        if (user == null) {
            return false;
        }
        if (SecurityHelper.isAdmin(user)) {
            return true;
        }
        for (Group each : cacheManager.getGroups(user.getId())) {
            if (!each.isAgentAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean isScriptAllowed(User user) {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        if (SecurityHelper.isAdmin(user)) {
            return true;
        }
        if (user == null) {
            Group anonymousGroup = cacheManager.getGroup("anonymous");
            return anonymousGroup != null && anonymousGroup.isScriptAllowed();
        }
        for (Group each : cacheManager.getGroups(user.getId())) {
            if (!each.isScriptAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean isShareDashboardAllowed(User user) {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        if (SecurityHelper.isAdmin(user)) {
            return true;
        }
        if (user == null) {
            Group anonymousGroup = cacheManager.getGroup("anonymous");
            return anonymousGroup != null && anonymousGroup.isShareDashboardAllowed();
        }
        for (Group each : cacheManager.getGroups(user.getId())) {
            if (!each.isShareDashboardAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean isShareDashboardAllowed() {
        return SecurityHelper.isShareDashboardAllowed(Context.getUser());
    }

    public static boolean isViewAlertsAllowed(User user) {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        if (SecurityHelper.isAdmin(user)) {
            return true;
        }
        if (user == null) {
            Group anonymousGroup = cacheManager.getGroup("anonymous");
            return anonymousGroup != null && anonymousGroup.isViewAlertsAllowed();
        }
        for (Group each : cacheManager.getGroups(user.getId())) {
            if (!each.isViewAlertsAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean isViewAlertsAllowed() {
        return SecurityHelper.isViewAlertsAllowed(Context.getUser());
    }

    public static boolean isSystemLogAllowed() {
        return SecurityHelper.isSystemLogAllowed(Context.getUser());
    }

    public static boolean isExpandAllAllowed() {
        return SecurityHelper.isExpandAllAllowed(Context.getUser());
    }

    public static boolean isSystemLogAllowed(User user) {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        if (SecurityHelper.isAdmin(user)) {
            return true;
        }
        if (user == null) {
            Group anonymousGroup = cacheManager.getGroup("anonymous");
            return anonymousGroup != null && anonymousGroup.isSystemLogAllowed();
        }
        for (Group each : cacheManager.getGroups(user.getId())) {
            if (!each.isSystemLogAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean isNodeAttributesAllowed(User user) {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        if (SecurityHelper.isAdmin(user)) {
            return true;
        }
        if (user == null) {
            Group anonymousGroup = cacheManager.getGroup("anonymous");
            return anonymousGroup != null && anonymousGroup.isNodeAttributesAllowed();
        }
        for (Group each : cacheManager.getGroups(user.getId())) {
            if (!each.isNodeAttributesAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean isExpandAllAllowed(User user) {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        if (SecurityHelper.isAdmin(user)) {
            return true;
        }
        if (user == null) {
            Group anonymousGroup = cacheManager.getGroup("anonymous");
            return anonymousGroup != null && anonymousGroup.isExpandAllAllowed();
        }
        for (Group each : cacheManager.getGroups(user.getId())) {
            if (!each.isExpandAllAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean isRestAccessAllowed(User user) {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        if (SecurityHelper.isAdmin(user)) {
            return true;
        }
        if (user == null) {
            Group anonymousGroup = cacheManager.getGroup("anonymous");
            return anonymousGroup != null && anonymousGroup.isRestAccessAllowed();
        }
        for (Group each : cacheManager.getGroups(user.getId())) {
            if (!each.isRestAccessAllowed()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPermission(User user, Configuration configuration) {
        return SecurityHelper.hasPermission(user, configuration, null);
    }

    public static boolean hasPermission(Configuration configuration) {
        if (!Context.isBackend()) {
            return SecurityHelper.hasPermission(Context.getUser(), configuration);
        }
        return true;
    }

    public static boolean hasPermission(User user, Configuration configuration, String permission) {
        if (!Bootstrap.isServer()) {
            return true;
        }
        CacheManager cacheManager = Quickbuild.getInstance(CacheManager.class);
        ArrayList<Group> groups = new ArrayList<Group>();
        if (user == null) {
            Group anonymousGroup = cacheManager.getGroup("anonymous");
            if (anonymousGroup == null) {
                return false;
            }
            groups.add(anonymousGroup);
        } else {
            if (user.isRoot()) {
                return true;
            }
            groups.addAll(cacheManager.getGroups(user.getId()));
        }
        for (Group group : groups) {
            if (group.isAdmin()) {
                return true;
            }
            int minDistance = Integer.MAX_VALUE;
            Authorization nearestAuthorization = null;
            for (Authorization authorization : cacheManager.getAuthorizations(group.getId())) {
                int currentDistance = configuration.getInheritDistance(authorization.getConfiguration());
                if (currentDistance == -1 || currentDistance >= minDistance) continue;
                nearestAuthorization = authorization;
                minDistance = currentDistance;
            }
            if (nearestAuthorization == null) continue;
            if (permission == null) {
                return true;
            }
            ArrayList<String> permissions = nearestAuthorization.getPermissions();
            for (String eachPermission : permissions) {
                Long permissionSetId;
                PermissionSet permissionSet;
                if (eachPermission.equals(permission)) {
                    return true;
                }
                if (!NumberUtils.isDigits((String)eachPermission) || (permissionSet = CacheManager.instance.getPermissionSet(permissionSetId = Long.valueOf(eachPermission))) == null || !permissionSet.getPermissions().contains(permission)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPermission(Configuration configuration, String permission) {
        if (!Context.isBackend()) {
            return SecurityHelper.hasPermission(Context.getUser(), configuration, permission);
        }
        return true;
    }

    public static boolean hasPermission(String permission) {
        if (!Context.isBackend()) {
            return SecurityHelper.hasPermission(Context.getUser(), Context.getConfiguration(), permission);
        }
        return true;
    }

    public static boolean hasPermission() {
        return SecurityHelper.hasPermission((String)null);
    }

    public static boolean isAnonymousEnabled() {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        return Quickbuild.getInstance(CacheManager.class).getGroup("anonymous") != null;
    }

    public static boolean isSelfRegisterEnabled() {
        if (!Bootstrap.isServer()) {
            throw new UnsupportedOperationException("Permission check can only be done on server.");
        }
        return Quickbuild.getInstance(CacheManager.class).getGroup("register") != null;
    }

    public static User authenticate(String userName, String password, String ip) {
        Validate.notEmpty((String)userName);
        String passwordHash = password != null ? StringUtils.hash(password) : null;
        String correctedUserName = NameValidator.correct(userName);
        User user = UserManager.instance.get(correctedUserName);
        if (user != null) {
            if (user.isRoot() || user.getAuthenticator() == null || MainServlet.get() == null) {
                if (passwordHash == null || user.getPassword().equals(passwordHash)) {
                    return user;
                }
                if (ip != null) {
                    throw new AuthenticationException("Error authenticating user '" + correctedUserName + "' from ip '" + ip + "': User not found or password incorrect.");
                }
                throw new AuthenticationException("Error authenticating user '" + correctedUserName + "': User not found or password incorrect.");
            }
            List<Authenticator> authenticators = SettingManager.instance.getSecuritySetting().getAuthenticators(true);
            Authenticator lastAuthenticator = null;
            for (Authenticator authenticator : authenticators) {
                if (authenticator.isDisabled() || !authenticator.getName().equals(user.getAuthenticator())) continue;
                lastAuthenticator = authenticator;
                break;
            }
            if (lastAuthenticator != null) {
                logger.debug("Authenticating user '{}' through authenticator '{}'...", (Object)userName, (Object)lastAuthenticator.getName());
                AuthenticationResult result = lastAuthenticator.authenticate(userName, password);
                if (result != null) {
                    boolean userUpdated = false;
                    if (result.getFullName() != null && !result.getFullName().equals(user.getFullName())) {
                        user.setFullName(result.getFullName());
                        userUpdated = true;
                    }
                    if (result.getEmail() != null && !result.getEmail().equals(user.getEmail())) {
                        user.setEmail(result.getEmail());
                        userUpdated = true;
                    }
                    if (passwordHash != null && !passwordHash.equals(user.getPassword())) {
                        user.setPassword(passwordHash);
                        userUpdated = true;
                    }
                    if (userUpdated) {
                        UserManager.instance.save(user);
                    }
                    result.correctGroupNames();
                    if (!result.getGroupNames().isEmpty()) {
                        logger.debug("Retrieved groups for user '{}' from authenticator: {}", (Object)userName, (Object)StringUtils.join(result.getGroupNames()));
                    } else {
                        logger.debug("No group information is retrieved for user '{}' from authenticator.", (Object)userName);
                    }
                    HashMap<String, Group> groups = new HashMap<String, Group>();
                    for (String groupName : result.getGroupNames()) {
                        Group group = CacheManager.instance.getGroup(groupName);
                        if (group == null) {
                            logger.debug("Ignore group '{}' for user '{}' as it is not defined in QuickBuild.", (Object)groupName, (Object)userName);
                            continue;
                        }
                        groups.put(groupName, group);
                    }
                    if (!groups.isEmpty() && !((Object)groups.keySet()).equals(user.getGroupNames())) {
                        MembershipManager.instance.assign(user, groups.values(), false);
                    }
                    return user;
                }
            } else {
                for (Authenticator authenticator : authenticators) {
                    if (authenticator.isDisabled()) continue;
                    logger.debug("Authenticating user '{}' through authenticator '{}'...", (Object)userName, (Object)authenticator.getName());
                    AuthenticationResult result = authenticator.authenticate(userName, password);
                    if (result == null) continue;
                    boolean userUpdated = false;
                    if (!authenticator.getName().equals(user.getAuthenticator())) {
                        user.setAuthenticator(authenticator.getName());
                        userUpdated = true;
                    }
                    if (result.getFullName() != null && !result.getFullName().equals(user.getFullName())) {
                        user.setFullName(result.getFullName());
                        userUpdated = true;
                    }
                    if (result.getEmail() != null && !result.getEmail().equals(user.getEmail())) {
                        user.setEmail(result.getEmail());
                        userUpdated = true;
                    }
                    if (passwordHash != null && !passwordHash.equals(user.getPassword())) {
                        user.setPassword(passwordHash);
                        userUpdated = true;
                    }
                    if (userUpdated) {
                        UserManager.instance.save(user);
                    }
                    result.correctGroupNames();
                    if (!result.getGroupNames().isEmpty()) {
                        logger.debug("Retrieved groups for user '{}' from authenticator: {}", (Object)userName, (Object)StringUtils.join(result.getGroupNames()));
                    } else {
                        logger.debug("No group information is retrieved for user '{}' from authenticator.", (Object)userName);
                    }
                    HashMap<String, Group> groups = new HashMap<String, Group>();
                    for (String groupName : result.getGroupNames()) {
                        Group group = CacheManager.instance.getGroup(groupName);
                        if (group == null) {
                            logger.debug("Ignore group '{}' for user '{}' as it is not defined in QuickBuild.", (Object)groupName, (Object)userName);
                            continue;
                        }
                        groups.put(groupName, group);
                    }
                    if (!groups.isEmpty() && !((Object)groups.keySet()).equals(user.getGroupNames())) {
                        MembershipManager.instance.assign(user, groups.values(), false);
                    }
                    return user;
                }
            }
        } else if (RequestCycle.get() != null || password == null) {
            for (Authenticator authenticator : Quickbuild.getInstance(SettingManager.class).getSecuritySetting().getAuthenticators(true)) {
                if (authenticator.isDisabled()) continue;
                logger.debug("Authenticating user '{}' through authenticator '{}'...", (Object)userName, (Object)authenticator.getName());
                AuthenticationResult result = authenticator.authenticate(userName, password);
                if (result == null) continue;
                user = new User();
                user.setName(correctedUserName);
                if (passwordHash != null) {
                    user.setPassword(passwordHash);
                } else {
                    user.setPassword(StringUtils.hash(UUID.randomUUID().toString()));
                }
                user.setFullName(result.getFullName());
                user.setEmail(result.getEmail());
                user.setAuthenticator(authenticator.getName());
                UserManager.instance.save(user);
                ArrayList<Group> groups = new ArrayList<Group>();
                result.correctGroupNames();
                if (!result.getGroupNames().isEmpty()) {
                    logger.debug("Retrieved groups for user '{}' from authenticator: {}", (Object)userName, (Object)StringUtils.join(result.getGroupNames()));
                } else {
                    logger.debug("No group information is retrieved for user '{}' from authenticator.", (Object)userName);
                }
                for (String groupName : result.getGroupNames()) {
                    Group group = CacheManager.instance.getGroup(groupName);
                    if (group == null) {
                        logger.debug("Ignore group '{}' for user '{}' as it is not defined in QuickBuild.", (Object)groupName, (Object)userName);
                        continue;
                    }
                    groups.add(group);
                }
                if (groups.isEmpty() && authenticator.getDefaultGroupName() != null) {
                    logger.debug("Use default group '{}' for user '{}' as the authenticator does not report any valid QuickBuild groups.", (Object)authenticator.getDefaultGroupName(), (Object)userName);
                    Group group = CacheManager.instance.getGroup(authenticator.getDefaultGroupName());
                    if (group == null) {
                        throw new QuickbuildException("Default group '" + authenticator.getDefaultGroupName() + "' for authenticator '" + authenticator.getName() + "' is not found in QuickBuild.");
                    }
                    groups.add(group);
                }
                if (!groups.isEmpty()) {
                    MembershipManager.instance.assign(user, groups, false);
                }
                return user;
            }
            if (password == null) {
                user = new User();
                user.setName(correctedUserName);
                user.setPassword(StringUtils.hash(UUID.randomUUID().toString()));
                UserManager.instance.save(user);
                ArrayList<Group> groups = new ArrayList<Group>();
                String defaultGroupName = SettingManager.instance.getSecuritySetting().getTrustUserNameInHttpHeader().getDefaultGroupName();
                if (defaultGroupName != null) {
                    Group group = CacheManager.instance.getGroup(defaultGroupName);
                    if (group == null) {
                        throw new QuickbuildException("Default group '" + defaultGroupName + "' defined in security setting 'trust user in http header' is not found in QuickBuild.");
                    }
                    groups.add(group);
                }
                if (!groups.isEmpty()) {
                    MembershipManager.instance.assign(user, groups, false);
                }
                return user;
            }
        }
        if (ip != null) {
            throw new AuthenticationException("Error authenticating user '" + correctedUserName + "' from ip '" + ip + "': User not found or password incorrect.");
        }
        throw new AuthenticationException("Error authenticating user '" + correctedUserName + "': User not found or password incorrect.");
    }

    public static User authenticate(HttpServletRequest request, HttpServletResponse response) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null) {
            ip = request.getRemoteAddr();
        }
        HttpSession httpSession = request.getSession(false);
        WebSession wicketSession = null;
        if (httpSession != null && (wicketSession = (WebSession)((Object)httpSession.getAttribute("wicket:quickbuild:session"))) != null && wicketSession.getUserId() != null) {
            User user = (User)UserManager.instance.load(wicketSession.getUserId());
            user.getName();
            return user;
        }
        if (wicketSession == null || !wicketSession.isIgnoreAuthenticationHeaders()) {
            String protocol;
            String userName;
            SecuritySetting securitySetting = SettingManager.instance.getSecuritySetting();
            TrustUserNameInHttpHeader trustSetting = securitySetting.getTrustUserNameInHttpHeader();
            if (trustSetting.getHeaderName() != null && (trustSetting.getTrustIps() == null || trustSetting.getTrustIps().isEmpty() || StringUtils.splitAndTrim(trustSetting.getTrustIps()).contains(request.getRemoteAddr())) && StringUtils.isNotBlank((String)(userName = request.getHeader(trustSetting.getHeaderName())))) {
                if (trustSetting.getConvertScript() != null) {
                    userName = (String)ScriptEngine.instance.evaluate(trustSetting.getConvertScript(), EasyMap.create("userName", userName));
                }
                User user = SecurityHelper.authenticate(userName, null, ip);
                if (wicketSession != null) {
                    wicketSession.setUserId(user.getId());
                }
                return user;
            }
            String authorizationHeader = request.getHeader("Authorization");
            if (authorizationHeader == null && httpSession != null) {
                authorizationHeader = (String)httpSession.getAttribute("Authorization");
            }
            if (authorizationHeader != null && (protocol = StringUtils.substringBefore((String)authorizationHeader, (String)" ")).toLowerCase().equals("basic")) {
                String token = StringUtils.substringAfter((String)authorizationHeader, (String)" ");
                token = new String(Base64.decodeBase64((byte[])token.getBytes()));
                String userName2 = StringUtils.substringBefore((String)token, (String)":");
                String password = StringUtils.substringAfter((String)token, (String)":");
                if (userName2 != null && password != null) {
                    User user = SecurityHelper.authenticate(userName2, password, ip);
                    if (wicketSession != null) {
                        wicketSession.setUserId(user.getId());
                    }
                    return user;
                }
            }
        }
        String userNameInCookie = CookieUtils.getCookieValue(request, COOKIE_USERNAME);
        String passwordInCookie = CookieUtils.getCookieValue(request, COOKIE_PASSWORD);
        if (userNameInCookie != null && passwordInCookie != null) {
            try {
                passwordInCookie = StringUtils.decrypt(passwordInCookie);
            }
            catch (Exception e) {
                passwordInCookie = "";
            }
            try {
                User user = SecurityHelper.authenticate(userNameInCookie, passwordInCookie, ip);
                if (wicketSession != null) {
                    wicketSession.setUserId(user.getId());
                }
                return user;
            }
            catch (Exception e) {
                SecurityHelper.clearAuthenticationCookies(response);
                throw ExceptionUtils.wrapAsUnchecked(e);
            }
        }
        return null;
    }

    public static void checkAgentToken(HttpServletRequest request) {
        HttpServletRequest httpRequest = request;
        String authorizationHeader = httpRequest.getHeader("Authorization");
        boolean authorized = false;
        if (authorizationHeader != null) {
            String agentToken = StringUtils.substringAfter((String)authorizationHeader, (String)" ");
            agentToken = new String(Base64.decodeBase64((byte[])agentToken.getBytes()));
            if (Bootstrap.isAgent()) {
                if (agentToken.equals(Bootstrap.getAgentToken())) {
                    authorized = true;
                }
            } else if (agentToken.indexOf(58) == -1) {
                if (CacheManager.instance.getToken(agentToken) != null) {
                    authorized = true;
                }
            } else {
                User user = CacheManager.instance.getUser(StringUtils.substringBefore((String)agentToken, (String)":"));
                if (user != null && user.getPassword().equals(StringUtils.substringAfter((String)agentToken, (String)":")) && CacheManager.instance.isAgentAllowed(user)) {
                    authorized = true;
                }
            }
        }
        if (!authorized) {
            throw new AccessDeniedException("Access denied for connection from '" + request.getRemoteAddr() + "'.");
        }
    }

    public static void respondWithAccessDenied(HttpServletResponse response) {
        if (Context.getUser() != null) {
            try {
                response.sendError(403, "Access denied.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            String authRequest = "Basic realm=\"QuickBuild\"";
            response.setHeader("WWW-Authenticate", authRequest);
            response.setStatus(401);
        }
    }

    public static void createAuthenticationCookies(HttpServletResponse response, String userName, String password) {
        CookieUtils.saveCookie(response, COOKIE_USERNAME, userName);
        CookieUtils.saveCookie(response, COOKIE_PASSWORD, StringUtils.encrypt(password));
    }

    public static void clearAuthenticationCookies(HttpServletResponse response) {
        CookieUtils.removeCookie(response, COOKIE_USERNAME);
        CookieUtils.removeCookie(response, COOKIE_PASSWORD);
    }

    public static String generateAccessToken(User user, Date validUntil) {
        String token = user.getId() + ".";
        token = token + StringUtils.encrypt(String.valueOf(validUntil.getTime()), user.getPassword());
        return token;
    }

    public static Pair<User, Date> parseAccessToken(String token) {
        Long userId = Long.valueOf(StringUtils.substringBefore((String)token, (String)"."));
        User user = (User)UserManager.instance.load(userId);
        Date validUntil = new Date(Long.valueOf(StringUtils.decrypt(StringUtils.substringAfter((String)token, (String)"."), user.getPassword())));
        return new Pair<User, Date>(user, validUntil);
    }
}

