/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.security;

import com.pmease.quickbuild.Quickbuild;
import com.pmease.quickbuild.annotation.ChoiceProvider;
import com.pmease.quickbuild.annotation.Editable;
import com.pmease.quickbuild.annotation.ImplementationProvider;
import com.pmease.quickbuild.annotation.Multiline;
import com.pmease.quickbuild.annotation.Name;
import com.pmease.quickbuild.entitymanager.GroupManager;
import com.pmease.quickbuild.extensionpoint.AuthenticatorProvider;
import com.pmease.quickbuild.extensionpoint.support.TypeInstance;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.pluginsupport.PluginManager;
import com.pmease.quickbuild.security.AuthenticationResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.hibernate.validator.constraints.NotEmpty;

@ImplementationProvider(method="getImplementations")
public abstract class Authenticator
extends TypeInstance {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private boolean disabled = false;
    private String defaultGroupName;

    @Editable(order=10)
    @NotEmpty
    @Name
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Editable(order=20)
    @Multiline
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Editable(order=30, description="Check this if you want to temporarily disable this authenticator.")
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Editable(order=10000, name="Default Group", description="For authenticated users, the default group will be used if group information of the user is not fetched from this external authentication system. If left empty, no default group will be assumed.")
    @ChoiceProvider(value="getAllGroupNames")
    public String getDefaultGroupName() {
        return this.defaultGroupName;
    }

    public void setDefaultGroupName(String defaultGroupName) {
        this.defaultGroupName = defaultGroupName;
    }

    private static List<String> getAllGroupNames() {
        return Quickbuild.getInstance(GroupManager.class).getGroupNames();
    }

    public abstract AuthenticationResult authenticate(String var1, String var2);

    private static Collection<Class<?>> getImplementations() {
        HashSet implementations = new HashSet();
        for (AuthenticatorProvider provider : Quickbuild.getInstance(PluginManager.class).getExtensions(AuthenticatorProvider.class)) {
            Class<? extends Authenticator> authenticatorClass = provider.getAuthenticatorClass();
            if (authenticatorClass == null) continue;
            implementations.add(authenticatorClass);
        }
        return implementations;
    }

    private void migrate1(VersionedDocument dom, Stack<Integer> versions) {
        dom.getRootElement().addElement("disabled").setText("false");
    }
}

