/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.entitymanager.UserManager;
import com.pmease.quickbuild.migration.VersionedDocument;
import com.pmease.quickbuild.model.User;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/users")
public class UserResource {
    @GET
    public Collection<User> list() {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return UserManager.instance.getAll();
    }

    @POST
    public Long save(User user) {
        if (!SecurityHelper.isAdmin() && !user.equals(Context.getUser())) {
            throw new AccessDeniedException();
        }
        BeanUtils.validate(user);
        for (VersionedDocument dom : user.getPluginSettingDOMs().values()) {
            dom.validate();
        }
        if (Context.getUser() != null && Context.getUser().getId().equals(user.getId())) {
            Context.getUser().getFavoriteDashboardIds().clear();
            Context.getUser().getFavoriteDashboardIds().addAll(user.getFavoriteDashboardIds());
            Context.getUser().setName(user.getName());
            Context.getUser().setFullName(user.getFullName());
            Context.getUser().setEmail(user.getEmail());
            Context.getUser().setAuthenticator(user.getAuthenticator());
            Context.getUser().setPassword(user.getPassword());
            Context.getUser().setPluginSettingDOMs(user.getPluginSettingDOMs());
            UserManager.instance.save(Context.getUser());
        } else {
            UserManager.instance.save(user);
        }
        return user.getId();
    }

    @Path(value="/{id}")
    @GET
    public User get(@PathParam(value="id") Long id) {
        User user = (User)UserManager.instance.load(id);
        if (!SecurityHelper.isAdmin() && !user.equals(Context.getUser())) {
            throw new AccessDeniedException();
        }
        return user;
    }

    @Path(value="/{id}/name")
    @GET
    public String getName(@PathParam(value="id") Long id) {
        User user = (User)UserManager.instance.load(id);
        return user.getName();
    }

    @Path(value="/{id}/display_name")
    @GET
    public String getDisplayName(@PathParam(value="id") Long id) {
        User user = (User)UserManager.instance.load(id);
        return user.getDisplayName();
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        UserManager.instance.delete(UserManager.instance.load(id));
    }
}

