/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.QuickbuildException;
import com.pmease.quickbuild.grid.Grid;
import com.pmease.quickbuild.grid.GridNode;
import com.pmease.quickbuild.security.SecurityHelper;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

@Path(value="/user_attributes/{node_address}")
public class UserAttributesResource {
    @GET
    public Map<String, String> get(@PathParam(value="node_address") String nodeAddress) {
        if (!SecurityHelper.isNodeAttributesAllowed(Context.getUser())) {
            throw new AccessDeniedException();
        }
        GridNode node = Grid.instance.getNode(nodeAddress);
        if (node == null) {
            throw new QuickbuildException("Unable to find node: " + nodeAddress);
        }
        return node.getUserAttributes();
    }

    @POST
    public void save(@PathParam(value="node_address") String nodeAddress, Map<String, String> userAttributes) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        GridNode node = Grid.instance.getNode(nodeAddress);
        if (node == null) {
            throw new QuickbuildException("Unable to find node: " + nodeAddress);
        }
        node.setUserAttributes(userAttributes, true);
    }
}

