/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.BuildEngine;
import com.pmease.quickbuild.BuildRequest;
import com.pmease.quickbuild.Context;
import com.pmease.quickbuild.RequestResult;
import com.pmease.quickbuild.entitymanager.AuditManager;
import com.pmease.quickbuild.entitymanager.ConfigurationManager;
import com.pmease.quickbuild.model.Configuration;
import com.pmease.quickbuild.security.ConfigurationPermission;
import com.pmease.quickbuild.security.SecurityHelper;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;

@Path(value="trigger")
public class TriggerResource {
    @GET
    public RequestResult query(@QueryParam(value="configuration_id") Long configurationId) {
        Configuration configuration = (Configuration)ConfigurationManager.instance.load(configurationId);
        if (!SecurityHelper.hasPermission(configuration, ConfigurationPermission.RUN_BUILD.name())) {
            throw new AccessDeniedException();
        }
        BuildRequest request = new BuildRequest();
        request.setConfigurationId(configurationId);
        RequestResult result = BuildEngine.instance.requestBuild(Context.getUser(), false, request);
        if (configuration.findAuditBuildRequest().booleanValue()) {
            AuditManager.instance.audit(configuration, "Build was requested via REST.");
        }
        return result;
    }
}

