/*
 * Decompiled with CFR 0.152.
 */
package com.pmease.quickbuild.rest.resources;

import com.pmease.quickbuild.AccessDeniedException;
import com.pmease.quickbuild.CacheManager;
import com.pmease.quickbuild.entitymanager.TokenManager;
import com.pmease.quickbuild.model.Token;
import com.pmease.quickbuild.security.SecurityHelper;
import com.pmease.quickbuild.util.BeanUtils;
import java.util.Collection;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

@Path(value="/tokens")
public class TokenResource {
    @Path(value="authorize")
    @GET
    public Long authorize(@QueryParam(value="ip") String ip, @QueryParam(value="port") int port) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        Token token = new Token();
        token.setIp(ip);
        token.setPort(port);
        token.setHostName("Unknown");
        token.setValue(UUID.randomUUID().toString());
        TokenManager.instance.save(token);
        return token.getId();
    }

    @Path(value="unauthorize")
    @GET
    public Long unauthorize(@QueryParam(value="ip") String ip, @QueryParam(value="port") int port) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        Token token = CacheManager.instance.getToken(ip, port);
        if (token == null) {
            return null;
        }
        TokenManager.instance.delete(token);
        return token.getId();
    }

    @GET
    public Collection<Token> list() {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return TokenManager.instance.getAll();
    }

    @POST
    public Long save(Token token) {
        BeanUtils.validate(token);
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        TokenManager.instance.save(token);
        return token.getId();
    }

    @Path(value="/{id}")
    @GET
    public Token get(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        return (Token)TokenManager.instance.load(id);
    }

    @Path(value="/{id}")
    @DELETE
    public void delete(@PathParam(value="id") Long id) {
        if (!SecurityHelper.isAdmin()) {
            throw new AccessDeniedException();
        }
        Token token = (Token)TokenManager.instance.load(id);
        TokenManager.instance.delete(token);
    }
}

